;;; backquote-tests.el --- Tests for backquote.el -*- lexical-binding: t -*-

;; Copyright (C) 2019-2026 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(require 'ert)

(ert-deftest backquote-test-basic ()
  (let ((lst '(ba bb bc))
        (vec [ba bb bc]))
    (should (equal 3 `,(eval '(+ x y) '((x . 1) (y . 2)))))
    (should (equal vec `[,@lst]))
    (should (equal `(a lst c) '(a lst c)))
    (should (equal `(a ,lst c) '(a (ba bb bc) c)))
    (should (equal `(a ,@lst c) '(a ba bb bc c)))
    ;; Vectors work just like lists.
    (should (equal `(a vec c) '(a vec c)))
    (should (equal `(a ,vec c) '(a [ba bb bc] c)))
    (should (equal `(a ,@vec c) '(a ba bb bc c)))))

(ert-deftest backquote-test-nested ()
  "Test nested backquotes."
  (let ((lst '(ba bb bc))
        (vec [ba bb bc]))
    (should (equal `(a ,`(,@lst) c) `(a ,lst c)))
    (should (equal `(a ,`[,@lst] c) `(a ,vec c)))
    (should (equal `(a ,@`[,@lst] c) `(a ,@lst c)))))

;;; backquote-tests.el ends here
